function tabChange(titleObj,conObj){
	$("."+titleObj+" ul").click(function(){
		$(this).addClass("selected").siblings().removeClass("selected");
		var activeIndex = $(this).index();
		$("."+conObj+" ul:eq("+activeIndex+")").show().siblings().hide();
	})
}

//-- Length Conversion
function conv_length(){
	LengthUnit= new Array(5);
	LengthUnit[0]=25.4;
	LengthUnit[1]=25.4*12;
	LengthUnit[2]=1;
	LengthUnit[3]=10;
	LengthUnit[4]=1000;

	userin=document.cv_length.in_length.value;
	if (userin == 0){
		userin=1.0;
		document.cv_length.in_length.value=userin;
	}
	baseval=eval(userin);
	if (baseval<0){
		baseval=-baseval;
	}

	Index=document.cv_length.in_unit.selectedIndex;
	out_val=baseval*LengthUnit[Index];

	document.cv_length.out_in.value=Math.round(out_val/LengthUnit[0]*1000)/1000;
	document.cv_length.out_ft.value=Math.round(out_val/LengthUnit[1]*1000)/1000;
	document.cv_length.out_mm.value=Math.round(out_val/LengthUnit[2]*100)/100;
	document.cv_length.out_cm.value=Math.round(out_val/LengthUnit[3]*1000)/1000;
	document.cv_length.out_m.value=Math.round(out_val/LengthUnit[4]*100000)/100000;

}

//-- Temperature Conversion
function conv_temp(){
	userin=document.cv_temp.in_temp.value;
	if (userin == 0){
		userin=25.0;
		document.cv_temp.in_temp.value=userin;
	}
	baseval=eval(userin);

	Index=document.cv_temp.in_unit.selectedIndex;
	if (Index == 0){
		document.cv_temp.out_C.value=Math.round(baseval*100)/100;
		document.cv_temp.out_F.value=Math.round((baseval*9/5+32)*100)/100;
		document.cv_temp.out_K.value=Math.round((baseval+273.15)*100)/100;
	}else if (Index == 1){
		document.cv_temp.out_C.value=Math.round((5/9*(baseval-32))*100)/100;
		document.cv_temp.out_F.value=Math.round(baseval*100)/100;
		document.cv_temp.out_K.value=Math.round((5/9*(baseval-32)+273.15)*100)/100;
	}else{
		document.cv_temp.out_C.value=Math.round((baseval-273.15)*100)/100;
		document.cv_temp.out_F.value=Math.round(((baseval-273.15)*9/5+32)*100)/100;
		document.cv_temp.out_K.value=Math.round(baseval*100)/100;
	}
}

//-- Power Conversion
function conv_power(){
	PowerUnit= new Array(5);
	PowerUnit[0]=1;
	PowerUnit[1]=1000;
	PowerUnit[2]=0.29307;
	PowerUnit[3]=1;
	PowerUnit[4]=746;

	userin=document.cv_power.in_power.value;
	if (userin == 0){
		userin=1.0;
		document.cv_power.in_power.value=userin;
	}
	baseval=eval(userin);
	if (baseval<0){
		baseval=-baseval;
	}

	Index=document.cv_power.in_unit.selectedIndex;
	out_val=baseval*PowerUnit[Index];

	document.cv_power.out_w.value=Math.round(out_val/PowerUnit[0]*1000)/1000;
	document.cv_power.out_kw.value=Math.round(out_val/PowerUnit[1]*100000)/100000;
	document.cv_power.out_btu.value=Math.round(out_val/PowerUnit[2]*1000)/1000;
	document.cv_power.out_j.value=Math.round(out_val/PowerUnit[3]*1000)/1000;
	document.cv_power.out_hp.value=Math.round(out_val/PowerUnit[4]*100000)/100000;
}

//-- Pressure Conversion
function conv_press(){
	PressUnit= new Array(5);
	PressUnit[0]=1;
	PressUnit[1]=6894;
	PressUnit[2]=249.1;
	PressUnit[3]=3386;
	PressUnit[4]=133.3;

	userin=document.cv_press.in_press.value;
	if (userin == 0){
		userin=100.0;
		document.cv_press.in_press.value=userin;
	}
	baseval=eval(userin);
	if (baseval<0){
		baseval=-baseval;
	}

	Index=document.cv_press.in_unit.selectedIndex;
	out_val=baseval*PressUnit[Index];

	document.cv_press.out_p.value=Math.round(out_val/PressUnit[0]*100)/100;
	document.cv_press.out_psi.value=Math.round(out_val/PressUnit[1]*100000)/100000;
	document.cv_press.out_inh2o.value=Math.round(out_val/PressUnit[2]*100000)/100000;
	document.cv_press.out_inhg.value=Math.round(out_val/PressUnit[3]*100000)/100000;
	document.cv_press.out_mmhg.value=Math.round(out_val/PressUnit[4]*100000)/100000;
}


//-- Thermal Conductivity Conversion
	function conv_conductivity(){
		ConductivityUnit= new Array(5);
		ConductivityUnit[0]=1;
		ConductivityUnit[1]=1.730735;
		ConductivityUnit[2]=0.1442279;
		ConductivityUnit[3]=418.4;
		ConductivityUnit[4]=4.184;

		userin=document.cv_conductivity.in_conductivity.value;
		if (userin == 0){
			userin=1.0;
			document.cv_conductivity.in_conductivity.value=userin;
		}
		baseval=eval(userin);
		if (baseval<0){
			baseval=-baseval;
		}

		Index=document.cv_conductivity.in_unit.selectedIndex;
		out_val=baseval*ConductivityUnit[Index];

		document.cv_conductivity.out_Wmk.value=Math.round(out_val/ConductivityUnit[0]*1000)/1000;
		document.cv_conductivity.out_BTUhrftF.value=Math.round(out_val/ConductivityUnit[1]*100000)/100000;
		document.cv_conductivity.out_BTUhrftFin.value=Math.round(out_val/ConductivityUnit[2]*100000)/100000;
		document.cv_conductivity.out_calseccmC.value=Math.round(out_val/ConductivityUnit[3]*1000000)/1000000;
		document.cv_conductivity.out_calsecmC.value=Math.round(out_val/ConductivityUnit[4]*10000)/10000;
	}

//-- Thermal Resistance Conversion
	function conv_resistance(){
		ResistanceUnit= new Array(3);
		ResistanceUnit[0]=1;
		ResistanceUnit[1]=1.895634;
		ResistanceUnit[2]=0.000526565;

		userin=document.cv_resistance.in_resistance.value;
		if (userin == 0){
			userin=1.0;
			document.cv_resistance.in_resistance.value=userin;
		}
		baseval=eval(userin);
		if (baseval<0){
			baseval=-baseval;
		}

		Index=document.cv_resistance.in_unit.selectedIndex;
		out_val=baseval*ResistanceUnit[Index];

		document.cv_resistance.out_CW.value=Math.round(out_val/ResistanceUnit[0]*1000)/1000;
		document.cv_resistance.out_FhrBTU.value=Math.round(out_val/ResistanceUnit[1]*10000)/10000;
		document.cv_resistance.out_FsecBTU.value=Math.round(out_val/ResistanceUnit[2]*1000)/1000;
	}

//-- Thermal Conductance Conversion
	function conv_conductance(){
		ConductanceUnit= new Array(3);
		ConductanceUnit[0]=1;
		ConductanceUnit[1]=0.527537;
		ConductanceUnit[2]=1898.97455;

		userin=document.cv_conductance.in_conductance.value;
		if (userin == 0){
			userin=1.0;
			document.cv_conductance.in_conductance.value=userin;
		}
		baseval=eval(userin);
		if (baseval<0){
			baseval=-baseval;
		}

		Index=document.cv_conductance.in_unit.selectedIndex;
		out_val=baseval*ConductanceUnit[Index];

		document.cv_conductance.out_wk.value=Math.round(out_val/ConductanceUnit[0]*1000)/1000;
		document.cv_conductance.out_BTUFhr.value=Math.round(out_val/ConductanceUnit[1]*10000)/10000;
		document.cv_conductance.out_BTUFsec.value=Math.round(out_val/ConductanceUnit[2]*1000000)/1000000;
	}
	
//-- Specific Heat Conversion
	function conv_specific_heat(){
		SpecificHeatUnit= new Array(3);
		SpecificHeatUnit[0]=1;
		SpecificHeatUnit[1]=4186.8;
		SpecificHeatUnit[2]=4186.8;

		userin=document.cv_specific_heat.in_specific_heat.value;
		if (userin == 0){
			userin=1.0;
			document.cv_specific_heat.in_specific_heat.value=userin;
		}
		baseval=eval(userin);
		if (baseval<0){
			baseval=-baseval;
		}

		Index=document.cv_specific_heat.in_unit.selectedIndex;
		out_val=baseval*SpecificHeatUnit[Index];

		document.cv_specific_heat.out_JKgC.value=Math.round(out_val/SpecificHeatUnit[0]*1000)/1000;
		document.cv_specific_heat.out_BTUlbmF.value=Math.round(out_val/SpecificHeatUnit[1]*1000000)/1000000;
		document.cv_specific_heat.out_calgC.value=Math.round(out_val/SpecificHeatUnit[2]*1000000)/1000000;
	}
	
//-- Airflow Velocity Conversion
	function conv_air(loc_code){
		VelUnit= new Array(6);
		VelUnit[0]=.00508;//LFM
		VelUnit[1]=1;//m/s
		VelUnit[2]=.44704;//MPH
		VelUnit[3]=1/2118.88;//CFM
		VelUnit[4]=1/3600;//m^3/hr
		VelUnit[5]=1/1000;//L/s

		AreaUnit= new Array(5);
		AreaUnit[0]=1; //in^2
		AreaUnit[1]=144;//ft^2
		AreaUnit[2]=.001550031;//mm^2
		AreaUnit[3]=.1550031;//cm^2
		AreaUnit[4]=1550.0031;//m^2

		if (loc_code==1){
			tempin=document.cv_air.r_duct.value;
			if (tempin== 0){
				document.cv_air.r_duct.focus();
			}
			return false;
		} else if (loc_code==2){	
			tempin=document.cv_air.h_duct.value;
			if (tempin== 0){
				document.cv_air.h_duct.focus();
			}
			return false;
			tempin=document.cv_air.w_duct.value;
			if (tempin== 0){
				document.cv_air.w_duct.focus();
			}
			return false;
		}		

		userin=document.cv_air.in_air.value;
		if (userin == 0){
			userin=400.0;
			document.cv_air.in_air.value=userin;
		}
		vel_in=eval(userin);
		if (vel_in<0){
			vel_in=-vel_in;
		}
		userin=document.cv_air.duct_type[0].checked;
		if (userin){
			tempin=document.cv_air.h_duct.value;
			if (tempin== 0){
				tempin=2;
				document.cv_air.h_duct.value=tempin;
			}
			height_in=eval(tempin);
			tempin=document.cv_air.w_duct.value;
			if (tempin== 0){
				tempin=2;
				document.cv_air.w_duct.value=tempin;
			}
			width_in=eval(tempin);
			area_in=width_in*height_in;
			Index2=document.cv_air.in_unit3.selectedIndex;
		} else {
			tempin=document.cv_air.r_duct.value;
			if (tempin== 0){
				tempin=2.0;
				document.cv_air.r_duct.value=tempin;
			}
			radius_in=eval(tempin);
			area_in=3.14159*radius_in*radius_in;
			Index2=document.cv_air.in_unit2.selectedIndex;
		}
		if (area_in<0){
			area_in=-area_in;
		}

		Index1=document.cv_air.in_unit1.selectedIndex;
		if (Index1 < 3){
			vel_out_val=vel_in*VelUnit[Index1];
			area_out_val=area_in*AreaUnit[Index2];
			flow_out_val=vel_out_val*area_out_val*.00064516;
			document.cv_air.out_lfm.value=Math.round(vel_out_val/VelUnit[0]*100)/100;
			document.cv_air.out_ms.value=Math.round(vel_out_val/VelUnit[1]*100)/100;
			document.cv_air.out_mph.value=Math.round(vel_out_val/VelUnit[2]*10)/10;

			document.cv_air.out_cfm.value=Math.round(flow_out_val/VelUnit[3]*100)/100;
			document.cv_air.out_m3hr.value=Math.round(flow_out_val/VelUnit[4]*100)/100;
			document.cv_air.out_ls.value=Math.round(flow_out_val/VelUnit[5]*100)/100;
		} else {
			flow_out_val=vel_in*VelUnit[Index1];
			area_out_val=area_in*AreaUnit[Index2]*.00064516;
			vel_out_val=flow_out_val/area_out_val;
			document.cv_air.out_lfm.value=Math.round(vel_out_val/VelUnit[0]*100)/100;
			document.cv_air.out_ms.value=Math.round(vel_out_val/VelUnit[1]*100)/100;
			document.cv_air.out_mph.value=Math.round(vel_out_val/VelUnit[2]*10)/10;

			document.cv_air.out_cfm.value=Math.round(flow_out_val/VelUnit[3]*100)/100;
			document.cv_air.out_m3hr.value=Math.round(flow_out_val/VelUnit[4]*100)/100;
			document.cv_air.out_ls.value=Math.round(flow_out_val/VelUnit[5]*100)/100;
		}
	}