var product = product || {}
product = (function() {
	var http = new Httpserver()
	var type = getUrlParam("type") || 0
	var vm_product
	var weuiLoading

	//初始化
	function init() {
		const app = Vue.createApp({
			data() {
				return {
					categoryArr: [],
					category_num:0,
					category_id:getUrlParam("category_id") ||0,
					categoryID:0,
					
					seriesArr:[],
					series_num:0,
					series_id:getUrlParam("series_id")||0,
					
					productArr:[],
					product_num:0,
					product_id:getUrlParam("id")||0,
					
					productInfo:null,
					
					seriesPage:1,
					seriesTotalPage:1,
					
					productPage:1,
					productTotalPage:1,
					
					selectIDArr:[],
					
					time:200,
				}
			},
			mounted() {
				this.getCategory()
			},
			methods: {
				getCategory() {//类别
				weuiLoading = weui.loading('loading...', {
					className: 'custom-loading'
				})
					http.getCategory().then((res) => {
						if (res.status == 1) {
							this.categoryArr = [...res.list[0].sublist, ...res.list[1].sublist,
								...res.list[2].sublist
							]
							if (type == 1) {
								this.category_num = 0
							} else if (type == 2) {
								this.category_num = res.list[0].sublist.length
							} else if (type == 3) {
								this.category_num = res.list[0].sublist.length + res.list[1].sublist.length
							} else {
								this.category_num = 0
							}
							
							if(this.category_id!=0){
								this.category_num =this.categoryArr.findIndex(item => item.category_id === this.category_id)
							}
							
							if(this.category_num==-1){
								this.category_num=0
								this.updateSeries(this.categoryArr[this.category_num].category_id,this.category_num)
							}else{
								this.updateSeries(this.categoryArr[this.category_num].category_id,this.category_num)
							}
						}
					})
				},
				updateSeries(id,index){//类别切换
					this.category_num=index
					this.category_id=id
					this.categoryID=id
					this.getSeries(id)
				},
				getSeries(id){//系列
					let param = {
						category_id: id
					}
					weuiLoading = weui.loading('loading...', {
						className: 'custom-loading'
					})
					http.getSeries(param).then((res) => {
						if (res.status == 1) {
							if (res.list_num == 0) {
								this.seriesArr = []
								this.productArr=[]
							} else {
								this.seriesArr = res.list
								
								this.series_num=this.seriesArr.findIndex(item => item.series_id === this.series_id)
								if(this.series_num==-1){
									this.series_num = 0
									this.updateProduct(this.seriesArr[this.series_num].series_id,this.series_num)
								}else{
									this.updateProduct(this.series_id,this.series_num)
								}
								
								this.seriesPage = Math.ceil((this.series_num+1) / 4)
								if(this.seriesPage==0){
									this.seriesPage=1
								}
								console.log("this.seriesPage:"+this.seriesPage)
								this.seriesTotalPage = Math.ceil(this.seriesArr.length / 4)
								setTimeout(()=>{this.updatePage()},this.time)
							}
						}
					})
				},
				updateProduct(id,index){//更新产品型号
					this.series_num=index
					this.series_id=id
					this.getSeriesDetail(id)
				},
				getSeriesDetail(id){//获取产品型号数据
					let param={
						series_id:id
					}
					weuiLoading = weui.loading('loading...', {
						className: 'custom-loading'
					})
					http.getSeriesDetail(param).then((res)=>{
						weuiLoading.hide()
						if(res.status==1){
							if(res.list_num==0){
								this.productArr=[]
							}else{
								this.productArr=res.list
							}
							
							this.product_num=this.productArr.findIndex(item => item.detail_id === this.product_id)
							if(this.product_num==-1){
								this.product_num=0
							}
							this.showProduct(this.product_num)
							//
							this.productPage=Math.ceil((this.product_num+1)/3)
							if(this.productPage<=0){
								this.productPage=1
							}
							this.productTotalPage=Math.ceil(this.productArr.length/3)
							//
							this.category_id=0
							this.series_id=0
							this.product_num=0
							this.time=0
						}
					})
				},
				showProduct(index){
					this.product_num=index
					this.productInfo=this.productArr[index]
				},
				prevPage(){
					this.seriesPage-=1
					if(this.seriesPage<=1){
						this.seriesPage=1
					}
					this.updatePage()
				},
				nextPage(){
					this.seriesPage+=1
					if(this.seriesPage>=this.seriesTotalPage){
						this.seriesPage=this.seriesTotalPage
					}
					this.updatePage()
				},
				updatePage(){
					$(".series-list-con").css("transform","translateY("+(1-this.seriesPage)*228+"px)")
				},
				selectProduct(id) {
					if (this.selectIDArr.includes(id)) {
						this.selectIDArr = this.selectIDArr.filter(item => item !== id);
					} else {
						this.selectIDArr.push(id)
					}
				},
				toCompare() {
					window.open(`compare.html?id=${this.selectIDArr.toString()}`)
				},
				toProductDetails(id){
					window.open(`product_details.html?id=${id}`)
				}
			}
		})
		vm_product = app.mount('#productID')
	}
	init()
})()