var product_list = product_list || {}
product_list = (function() {
	var http = new Httpserver()
	var vm_product
	var weuiLoading
	//初始化
	function init() {
		const app = Vue.createApp({
			data() {
				return {
					product_listArr: [],

					pageArr: [],
					pageNo: 1,
					totalPage: 1,
					pageSize: 4,
					continue: 3,
					selectIDArr: []
				}
			},
			mounted() {
				getSelectData()
			},
			methods: {
				selectProduct(id) {
					if (this.selectIDArr.includes(id)) {
						this.selectIDArr = this.selectIDArr.filter(item => item !== id);
					} else {
						this.selectIDArr.push(id)
					}
				},
				toProductDetails(id) {
					window.location.href=`product_details.html?id=${id}&seri=1`
				},
				toCompare() {
					window.location.href=`compare.html?id=${this.selectIDArr.toString()}`
				},
				startAndEndNum() {
					let start = 0,
						end = 0
					start = this.pageNo - Math.floor(this.continue / 2)
					end = this.pageNo + Math.floor(this.continue / 2)
					if (this.totalPage < this.continue) {
						end = this.totalPage
					}
					if (start < 1) {
						start = 1
						end = this.continue
					}
					if (end > this.totalPage) {
						start = this.totalPage - this.continue+1
						end = this.totalPage
					}

					return {
						start,
						end
					}
				},
				updatePage(page) {
					this.pageNo = page
					//
					if (this.pageNo == 0) {
						this.pageNo = 1
					} else if (this.pageNo >= this.totalPage) {
						this.pageNo = this.totalPage
					}
					this.pageArr = this.product_listArr.slice((this.pageNo - 1) * this.pageSize, this.pageNo * this.pageSize)
				}

			}
		})
		vm_product = app.mount('#productID')
	}
	// 下拉======================================================================
	var isInit = true
	var nominal_voltage = getUrlParam("n") || ""
	var type_of_voltage = getUrlParam("t") || ""
	var dimensions_mm = getUrlParam("d") || ""
	if (dimensions_mm) {
		dimensions_mm = localStorage.getItem("d")
	}
	var airflow_from = getUrlParam("from") || ""
	var airflow_to = getUrlParam("to") || ""

	var dataInfo = null

	updateAirflow()
	init()

	function getSelectData() {
		if (!isInit) {
			nominal_voltage = $("#selectDC_Nominal").closest(".fs-wrap").find(".fs-label").text()
			type_of_voltage = $("#selectDC_Type").closest(".fs-wrap").find(".fs-label").text()
			dimensions_mm = $("#selectDC_Dimensions").closest(".fs-wrap").find(".fs-label").text()
			airflow_from = $(".airflowfrom").val()
			airflow_to = $(".airflowto").val()
		}
		isInit = false
		if (nominal_voltage.includes('Nominal')) {
			nominal_voltage = ''
		}
		if (type_of_voltage.includes('Type')) {
			type_of_voltage = ''
		}
		if (dimensions_mm.includes('Dimensions')) {
			dimensions_mm = ''
		}

		let param = {
			keywords: "",
			nominal_voltage: nominal_voltage,
			type_of_voltage: type_of_voltage,
			dimensions_mm: dimensions_mm,
			airflow_from: airflow_from,
			airflow_to: airflow_to
		}
		weuiLoading = weui.loading('loading...', {
			className: 'custom-loading'
		})
		http.filter(param).then((res) => {
			weuiLoading.hide()
			if (res.status == 1) {
				dataInfo = res
				if (res.productlist_num == 0) {
					vm_product.product_listArr = []
				} else {
					vm_product.product_listArr = res.productlist
					//
					vm_product.totalPage = Math.ceil(res.productlist.length / vm_product
						.pageSize)
					vm_product.pageNo = 1
					vm_product.pageArr = vm_product.product_listArr.slice((vm_product.pageNo -
							1) * vm_product.pageSize, vm_product.pageNo * vm_product
						.pageSize)
				}
				updateNominal()
				updateType()
				updateDimensions()
			}
		})
	}

	function updateNominal() {
		let localArr = dataInfo.nominal_voltagelist_num == 0 ? [] : dataInfo.nominal_voltagelist
		let count = localArr.length
		let ops = '<option value="0">Nominal voltage in V </option>'
		if (nominal_voltage == '' || count == 0) {
			ops = '<option value="0" selected>Nominal voltage in V </option>'
		}
		for (let i = 0; i < count; i++) {
			if (localArr[i] == nominal_voltage) {
				ops += `<option value="${localArr[i]}" selected>${localArr[i]}</option>`
			} else {
				ops += `<option value="${localArr[i]}">${localArr[i]}</option>`
			}
		}
		$("#selectDC_Nominal").empty()
		$("#selectDC_Nominal").append(ops)

		let element = $("#selectDC_Nominal")

		$(".selectDC_Nominal").empty()
		$(".selectDC_Nominal").append(element)

		$('#selectDC_Nominal').fSelect({
			placeholder: '',
			numDisplayed: 5,
			overflowText: '{n} selected',
			//searchText: 'Search',
			showSearch: false
		})
	}

	function updateType() {
		let localArr = dataInfo.type_of_voltagelist_num == 0 ? [] : dataInfo.type_of_voltagelist
		let count = localArr.length
		let ops = '<option value="0">Type of voltage </option>'
		if (type_of_voltage == '' || count == 0) {
			ops = '<option value="0" selected>Type of voltage </option>'
		}
		for (let i = 0; i < count; i++) {
			if (localArr[i] == type_of_voltage) {
				ops += `<option value="${localArr[i]}" selected>${localArr[i]}</option>`
			} else {
				ops += `<option value="${localArr[i]}">${localArr[i]}</option>`
			}
		}
		$("#selectDC_Type").empty()
		$("#selectDC_Type").append(ops)

		let element = $("#selectDC_Type")

		$(".selectDC_Type").empty()
		$(".selectDC_Type").append(element)

		$('#selectDC_Type').fSelect({
			placeholder: '',
			numDisplayed: 5,
			overflowText: '{n} selected',
			//searchText: 'Search',
			showSearch: false
		});
	}

	function updateDimensions() {
		let localArr = dataInfo.dimensions_mmlist_num == 0 ? [] : dataInfo.dimensions_mmlist
		let count = localArr.length
		let ops = '<option value="0">Dimensions in mm</option>'
		if (dimensions_mm == '' || count == 0) {
			ops = '<option value="0" selected>Dimensions in mm</option>'
		}
		for (let i = 0; i < count; i++) {
			if (localArr[i] == dimensions_mm) {
				ops += `<option value="${localArr[i]}" selected>${localArr[i]}</option>`
			} else {
				ops += `<option value="${localArr[i]}">${localArr[i]}</option>`
			}
		}
		$("#selectDC_Dimensions").empty()
		$("#selectDC_Dimensions").append(ops)

		let element = $("#selectDC_Dimensions")

		$(".selectDC_Dimensions").empty()
		$(".selectDC_Dimensions").append(element)

		$('#selectDC_Dimensions').fSelect({
			placeholder: '',
			numDisplayed: 5,
			overflowText: '{n} selected',
			//searchText: 'Search',
			showSearch: false
		});
	}

	function updateAirflow() {
		$(".airflowfrom").val(airflow_from)
		$(".airflowto").val(airflow_to)
	}

	function oninputHand() {
		getSelectData()
	}
	$(".reset").on("click", function() {
		$("#selectDC_Nominal").closest(".fs-wrap").find(".fs-label").text("")
		$("#selectDC_Type").closest(".fs-wrap").find(".fs-label").text("")
		$("#selectDC_Dimensions").closest(".fs-wrap").find(".fs-label").text("")
		$(".airflowfrom").val("")
		$(".airflowto").val("")
		getSelectData()
	})
	//
	return {
		getSelectData: getSelectData,
		oninputHand: oninputHand
	}
})()

function conv_press(a) {
	if (a == 'Nominal') {
		//product_list.getSelectData()
	}
}

function oninputHand() {
	product_list.oninputHand()
}